# Xenophobia towards asylum seekers: A survey of social theories

Michelle Peterie University of Queensland, Australia

David Neil University of Wollongong, Australia

# Abstract

In recent decades, there has been a global rise in fear and hostility towards asylum seekers. Xenophobia – or ‘fear of the stranger’ – has become a pressing issue in a range of disciplines. Several causal models have been proposed to explain this fear and the hostility it produces. However, disciplinary boundaries have limited productive dialogue between these approaches. This article draws connections between four of the main theories that have been advanced in the existing literature: (1) false belief accounts, (2) xenophobia as new racism, (3) sociobiological explanations and (4) xenophobia as an effect of capitalist globalisation. While this article cannot provide an exhaustive review of theories of xenophobia, it aims to present a useful comparative introduction to current research into the social aspects of xenophobia, particularly as these theories have been applied to asylum seekers. In bringing together divergent models, it also invites interdisciplinary engagement.

# Keywords

asylum seekers, capitalism, discourse, false belief, globalisation, racism, sociobiology, xenophobia

In recent decades, there has been a global rise in fear and hostility towards asylum seekers. This has been documented at the level of political and media discourse (Briskman, 2015; Klocker and Dunn, 2003; McKay et al., 2011; Ogan et al., 2018; Pedersen and Hartley, 2015), and frequently revealed in surveys of public opinion (Carson et al., 2016;

Crawley, 2005; Markus, 2013). Across the Western world, liberal democracies have implemented punitive ‘deterrence’ policies (Mainwaring and Silverman, 2017; Peterie, 2019a; Robjant et al., 2009). At the same time there has been a parallel increase in hate crime (Levin and McDevitt, 2002; Poynting and Mason, 2007; Poynting and Noble, 2004). Both phenomena have subjected asylum seekers to grave physical and psychological harm.

While xenophobia is by no means a new phenomenon (Briskman, 2015; Poynting and Mason, 2007), this climate of antipathy towards asylum seekers has led to renewed scholarly interest in xenophobia and its causes. Xenophobia – or ‘fear of the stranger’ (Ortona, 2017: 46) – has emerged as an important issue in a range of disciplines, and consequently there are a variety of causal models that aim to explain it. At times these models have directly critiqued each other (Kivisto, 2008; Ortona, 2017). For the most part, however, researchers have adopted a theoretical approach native to their discipline, without engaging with alternative accounts. This article describes four influential theories of xenophobia – (1) false belief accounts, (2) xenophobia as new racism, (3) sociobiological explanations, and (4) xenophobia as an effect of capitalist globalisation – and attempts to draw some comparisons and contrasts between them. In addition, it highlights important points of agreement between seemingly opposing views. While this article can provide only a selective sample – and not an exhaustive review – of contemporary models of xenophobia, it hopefully offers a useful introduction to the literature on the social aspects of xenophobia, particularly as these theories have been applied to asylum seekers.

# False beliefs

Many sociologists and social scientists studying xenophobic attitudes towards asylum seekers have examined how community fears and hostilities are produced at the level of political discourse. A key focus of this work has been the effects of misinformation. Scholars have shown that government and media discourses propagate erroneous information regarding the threat posed by asylum seekers and the legitimacy of their claims (Klocker and Dunn, 2003; Pedersen et al., 2006). Government policies have also been shown to have a communicative function that influences community attitudes (Mainwaring and Silverman, 2017; Poynting and Mason, 2007; Pugliese, 2008). This work contends that politically and discursively manufactured fears could be reduced by the dissemination of corrective information. As Pedersen et al. (2006: 105) posit, ‘if false beliefs about asylum seekers can be identified and corrected this may have a significant effect on changing these attitudes in a positive direction’ (see also Spinney and Nethery, 2013: 188). Indeed, research has found that structured educational interventions to dispel false beliefs can be effective in reducing negative attitudes over time (Pedersen et al., 2011).

Research from Australia shows a strong correlation between false beliefs and negative attitudes towards asylum seekers. A study by Markus (2013: 40) for instance, documented strong negative sentiment against asylum seekers in Australia, as well as the prevalence of false beliefs concerning this group. The majority of respondents in his study believed that asylum seekers were coming to Australia as economic migrants in search of ‘a better life’, rather than to escape situations of danger and persecution. Studies by Pedersen et al. (2005, 2006) report similar findings. Participants in both studies held a suite of false beliefs regarding asylum seekers, and these beliefs were strongly correlated with negative attitudes.

In seeking to explain the prevalence of these beliefs, researchers have typically pointed to the existence of corresponding tropes in mainstream political discourse and media reporting. The aforementioned study by Pedersen et al. (2006: 120), for instance, matched participants’ negative attitudes towards asylum seekers with the presence of false beliefs, before demonstrating that these false beliefs corresponded with ‘public comments made by our political leaders’. When asked about their opinions of asylum seekers, participants in this study reproduced the same political tropes that Australian politicians utilise in their statements. In a similar vein, Klocker and Dunn (2003) documented a close relationship between political leaders’ statements concerning asylum seekers and media reporting of these issues, showing that media outlets reproduced government narratives which vilified asylum seekers. McKay et al. (2012) demonstrated a comparable relationship between media tropes and community attitudes, showing that participants’ views reflected those presented in the mainstream media (see also Augoustinos and Quinn, 2003). As Pedersen and Hartley (2017: 1) note:

Because very few Australians have contact with asylum seekers, it is likely that much of the information that they receive and espouse comes from commentators and importantly, from politicians via the media. This information is often inaccurate and leads to what some researchers label ‘false beliefs’ – the acceptance of incorrect information as being true.

Put differently, this research suggests that political discourses shape media reporting, which may in turn influence community sentiment through the dissemination of misinformation (Klocker, 2004; Klocker and Dunn, 2003).

Such a model of political and media effect is often implicit in broader studies of political and media discourse. Extensive work has been undertaken, for instance, regarding the false beliefs that underpin asylum seeker discourses around the Western world. This scholarship has highlighted a range of government and media ‘lies’, including the notions (a) that asylum seekers have broken the law by entering the country without prior authorisation, even though seeking asylum is legal under international law (Burroughs, 2015; McAdam and Chong, 2014; Ogan et al., 2018); (b) that asylum seekers are economic migrants not ‘genuine’ refugees in need of protection, even though most arrivals go on to receive refugee status (Burroughs, 2015; Every and Augoustinos, 2007; McHugh-Dillon, 2015); and (c) that asylum seekers are dangerous individuals with terrorist affiliations, even though most forced migrants are themselves fleeing situations of violence and terror, and few asylum seekers have been convicted of terrorist offences (Briskman,, 2015; Green, 2003; Klocker and Dunn, 2003: 71; McKay et al., 2011; Ogan et al., 2018; Pedersen and Hartley, 2015: 13). In foregrounding and attempting to correct these false beliefs, scholars have sought to influence public sentiment and delegitimise the punitive policies that these claims justify.

Some researchers have extended this approach to show that government policies themselves have a communicative function. Most notably, they have argued that detaining asylum seekers in closed (often prison-like; see Peterie, 2018) facilities sends a strong message that asylum seekers are dangerous criminals and would-be terrorists (Peterie, 2019b). As Mainwaring and Silverman (2017: 22) write in the European context:

both the highly visible and subtler manifestations of detention imply the existence of a crisis of unregulated, undesirable migration; detention thus corroborates the populist impression that an out-of-control, unwanted, and potentially dangerous inflow of non-citizens is amassing at the gates while signalling that the state is working to identify and punish this population.

Put differently, the detained asylum seeker is transformed into a ‘spectacle to be witnessed and consumed’ (Pugliese, 2008: 210). Detention becomes evidence of (and not simply a response to) the danger posed by irregular migration, thus reinforcing erroneous views.

Significantly, while scholars in this tradition have at times suggested that ‘problematic government and media representations of asylum seekers are at the root of [. . .] negative public perceptions’ and hostilities (Klocker, 2004: 13), some researchers complicate this ‘propaganda model’ (Herman and Chomsky, 1988) by suggesting more complex causal relationships. Klocker (2004: 14) theorises a feedback loop, whereby ‘negative government and media representations of asylum seekers foster negative public perceptions and fears, which in turn provide justification, legitimation and electoral support for increasingly exclusive, harsh and deterrence-oriented asylum policies’. Equally, Pedersen and Hartley (2015: 8) observe that ‘if people are prejudiced, they are more likely to believe negative reports about asylum seekers’, suggesting that confirmation bias helps to explain false beliefs. This work has important connections with research on new racism.

# (New) Racism

Research regarding representations of asylum seekers in political and media discourse has not only underlined the misleading character of these portrayals; it has also shown that asylum seekers are discursively constructed as cultural Others. As such, racism – or prejudice against members of other racial or ethnic groups – has been a key analytical lens in discussions of xenophobic attitudes towards asylum seekers.

Scholars, working in a range of contexts, have drawn attention to deeply held national narratives that portray the country as homogeneously Anglo-Celtic (Jackson, 2018; Klocker, 2004: 3; Papastergiadis, 2004). From this perspective, asylum seekers with different skin colours have been interpreted as a threat to the national self. Writing in the European context, for instance, Linke and Smith (2009: 11) note that ‘blackness and criminality’ have become conflated, such that people of colour ‘are forced to inhabit the figure of the “illegal alien”, the enemy “outsider”, the “welfare sponger”, “pimp”, “drug dealer” and the “diseased body”’. ‘In this panoptic theatre of race’, they argue, ‘the figure of the black-terrorist-criminal is conjured on sight’ (Linke and Smith, 2009: 11).

However, much of the racism that underpins hostile asylum policies and discourses is disguised. Overt reference to race and skin colour have been replaced by ‘dog-whistle’ condemnations of ‘cultural’ (as distinct from biological) difference.

There is cross-disciplinary agreement that blatant forms of prejudice, commonly referred to as ‘old-fashioned racism,’ have been recently supplanted with a more subtle and covert variety [. . .]. Increasing social taboos during the past 50 years against openly expressing racist sentiments have led to the development of discursive strategies that present negative views of out-groups as reasonable and justified while at the same time protecting the speaker from charges of racism and prejudice. (Augoustinos and Every, 2007: 124)

While ‘new’ racism inherits many characteristics from ‘old-fashioned’ racism, it is distinguished in the literature by at least three characteristics. First, new racist discourses avoid making reference to biology. Prejudice and negative sentiments are still expressed, but they are justified with respect to the Other’s culture rather than their race or skin colour (Augoustinos and Every, 2007: 133). Second, new racism involves appeals to what is portrayed as ‘fact’ (Augoustinos and Every, 2007: 133). This strategy aims to portray negative attitudes as empirically justifiable judgments; race-related fears and hostilities are framed not as emotive opinions, but as evidencebacked truths (Every and Augoustinos, 2007: 414). Finally, new racism is marked by the use of verbal disclaimers to explicitly deny that the judgments expressed are a product of prejudice (Augoustinos and Every, 2007: 125). As van Dijk (1992: 87) observes, these disclaimers often take the form ‘I have nothing against blacks, but .’. They aim to pre-emptively defend the speaker against allegations of racism. The international body of literature concerning new racism (Every and Augoustinos, 2007: 412) shows that these rhetorical strategies function to rationalise race-related fears and hostilities, while allowing public figures – as well as the listeners who hear and appropriate these discourses – to avoid the social faux pas of overt (‘old-fashioned’) racism.

In understanding xenophobic attitudes towards asylum seekers through the framework of ‘new racism’, scholars have observed that physical markers of ethnicity are rarely evoked in mainstream migration discourse. Instead, negative portrayals of asylum seekers centre around notions of cultural and religious difference. Asylum seekers are frequently presented as cultural Others (Said, 2003) – that is, as people ‘against which one’s own identity can be defined, either explicitly or implicitly; and [. . .] against which one’s social practices, conventions and customs, values and beliefs can be contrasted’ (Poynting et al., 2004: 35).

In documenting the shift from biological to cultural characterisations of Otherness, scholars have often used the concept of ‘Islamophobia’ to describe the way that asylum seekers have been homogenised as uniformly Muslim, and to show how racial fears and hostilities have thus been projected onto the Islamic faith (Dunn et al., 2007: 574; Jackson, 2018; Klocker, 2004: 10–11; Maddox, 2004: 2; Ogan et al., 2013; Poynting and Briskman, 2018; Poynting et al., 2004; Randell-Moon, 2006). Negative portrayals of Islam are prominent in Christian majority nations, as are broader claims of links between the Islamic faith and terrorism (Dunn et al., 2007; Jackson, 2018; Nagel, 2016). While these pejorative discourses typically take on ‘national particularities’ (Jackson, 2018: 141) – for example, Islam is framed as a threat to free expression in Denmark, to sexual freedom in the Netherlands, to tolerance in Switzerland and to gender equality in France (Jackson, 2018: 138) – themes of danger and Otherness have been ubiquitous.

Furthermore, asylum seekers are not only ascribed a monolithic (Islamic) religion, but ‘Muslim’ has become synonymous with ‘Arab’ (Poynting et al., 2004: 59), such that Islam has come to denote a ‘racial category’ (Ogan et al., 2013: 42).

This structuring narrative of threat and Otherness is visible in the political and media discourses described earlier, and has thus been seen, by some, as part of the elite’s dissemination of false beliefs and phobia. The discursive construction of Otherness is central to both ‘false belief’ approaches to xenophobia and new racism. A key point of difference between these models, however, is whether current discourse is held to be productive of xenophobia, or whether it is understood as a transformation and redirection of older fears and prejudices.

# Sociobiology

Evolutionary approaches to xenophobia claim that moral dispositions – including tendencies towards xenophobia – are deeply rooted in the human psyche. Sociobiologists hold that ‘prosocial’ drives such as altruism and empathy, as well as seemingly ‘antisocial’ tendencies towards xenophobic fear and hostility, are behavioural traits that had survival value for early humans and were thus selected and passed on to future generations (Daly, 2015).

As Haidt (2012, 2013) explains, the argument for this view begins with an understanding of the conditions in which human character evolved. Early Homo sapiens lived in small, tight-knit groups, and while there was some intra-group competition, each individual’s survival depended absolutely on that of their tribe (Haidt, 2013: 293; Wilson, 2002). The tribes that survived – and whose members therefore lived to pass on their genes – were those whose members manifested trust and cooperation towards fellow group members, and hostility towards outsiders (Darwin, 1998: 134; Haidt, 2012: 151). The result of this competitive environment is a human character that is both selfish and (within tribal constraints) capable of profound self-sacrifice.

When I say that human nature is selfish, I mean that our minds contain a variety of mental mechanisms that make us adept at promoting our own interests, in competition with our peers. When I say that human nature is also groupish, I mean that our minds contain a variety of mental mechanisms that make us adept at promoting our group’s interests, in competition with other groups. (Haidt, 2012: 151).

From this perspective, contemporary xenophobia is an effect of the inherently tribal character of human psychology: that is, of a basic disposition towards ‘groupishness’ at the expense of ‘outgroups’ or members of other ‘tribes’ (Haidt, 2012: 151).

Social scientists have at times argued that evolutionary understandings of xenophobia are at odds with empirical research regarding the socio-political dimensions of negative attitudes towards outgroups. Kivisto (2008: 3), for instance, rejects the sociobiological model on the basis that xenophobic attitudes differ across time, increasing during periods of crisis and when political and media discourses actively incite fear. This evidence suggests that xenophobia should ‘be viewed as socially constructed and not as an inevitable feature of the human condition’. Ortona (2017: 39) makes a similar point, arguing that ‘were xenophobia a universal feature, we should expect to find it whenever one meets a stranger, as a basic imprinted trait. Empirical evidence suggests that this is not the case.’ These criticisms, however, misconstrue the evolutionary argument, positing a false dichotomy between the biological and the social. The sociobiological literature demonstrates, however, that latent psychological tendencies are only activated in some circumstances. While these scholars suggest that groupishness is innate and can be observed everywhere from the playground to international politics, social context therefore remains important. Different behavioural traits are said to emerge in response to different environmental circumstances, and the form in which a behavioural characteristic presents is shaped by social conditions.

Evolutionary perspectives have associated xenophobia with resource scarcity. In his emblematic work, Wilson (2004: 107) reflected on behaviours in the animal kingdom and argued that ‘territorial’ behaviour is typically associated with limited resources. More recently, scholars have suggested that prejudice against outgroups increases during periods of resource scarcity. Asylum seekers might thus face greater hostility during economic downturns, or from groups who perceive themselves to be comparatively disadvantaged (Crawley, 2005: 16; Sanchez-Mazas and Licata, 2015). As MacKenzie (2016: 32) explains:

Humans think of their support systems as a zero-sum game – so if one person gains, another must lose out. Such perceptions were accurate during our evolutionary history as huntergatherers when the appearance of others on our patch meant fewer mastodons or mushrooms for us [. . .] Modern capitalist economy is not a zero-sum game – if you add more workers, it grows. Regardless of this, our evolutionary hang-ups make it difficult to accept the economic sense in welcoming immigrants.

At times the sociobiological model thus adopts economic language. The groupish nature of humans is explained as an evolutionary strategy for the protection and maintenance of resources, particularly under conditions of scarcity.

In addition to stressing the role of material conditions in manifestations of xenophobia, sociobiological perspectives are broadly compatible with the aforementioned arguments regarding the role of misinformation and false beliefs in producing fear and hostility. Outgroup prejudice may be triggered by perceptions of scarcity, regardless of whether those perceptions are true (Sanchez-Mazas and Licata, 2015: 805). In this context, discursive narratives that frame asylum seekers as (for example) ‘economic migrants’ take on added significance (Burroughs, 2015; Every and Augoustinos, 2007; McHugh-Dillon, 2015). Discourses that frame asylum seekers as competitors for scarce resources may activate evolved triggers for outgroup hostility. Rather than portraying sociobiological approaches as guilty of a reductionist biological determinism, it is therefore important to see how this research can lend weight to sociological claims about the dangerous effects of xenophobic discourse. Finally, many contemporary sociobiologists recognise that group loyalties exist for many types of groups, not just kinship groups. The tribal response can be activated by socially constructed groups such as political parties, sports teams, religious communities and nation states (Haidt, 2012: 292). As such, the social processes through which the ‘self’ and ‘Other’ are constituted remain in the foreground.

# Capitalist globalisation

A prominent political-economic analysis of the global resurgence of nationalism and xenophobia understands these developments as part of a broader trend towards unbridled capitalism. Xenophobic fear and hostility, on this view, is a function of structural inequalities and, more specifically, a result of deliberate political strategies to maintain public support for capitalism despite the harms that it inflicts. This theory thus begins with a nuanced critique of the global economy and the way it produces inequality and precarity.

As Badiou (2015) observes, contemporary humans live in an era of triumphant capitalism, which, since the 1980s, has progressively imposed a neoliberal logic of production and exchange on all corners of the globe. The construction of global economic structures to realise a world system of resource mining, manufacturing and trade has seen entire societies reorganised to facilitate wealth extraction; it has also brought about the weakening of states (Badiou, 2015: 6; McGrew, 2010). The relative power of states and the transnational corporate behemoths that rule the world economy has shifted, such that corporate interests largely direct state policy in all matters that affect profit. The post-war welfare state sought to tame the more corrosive excesses of capitalism: to guarantee a basic suite of services and citizen rights, to preserve a measure of union power, to break up monopolies, to limit moral hazard in the activities of financial institutions, and to address the environmental externalities of manufacturing. In the last three decades, however, these constraints – and even the very capacity of the state to impose limits on capital – have been dismantled, such that it is now nearly impossible to make the largest corporations accept even minimal tax obligations in the countries where they are nominally based (Monbiot, 2016; Shaxson, 2011). Capitalism’s victory has also been won at the level of ideas: ‘It is the total eradication of the very idea of any other path’ (Badiou, 2015: 8). There is no effective opposition to capitalism; alternative visions of economic organisation are seen as forms of dangerous extremism and consigned to the fringes.

For theorists such as Badiou (2015) and Smith (2016), unfettered capitalism is realising a new brand of imperialism. When colonial powers divided up continents, they managed their territories through a metropolitan power installed in the dependent state. Rather than taking on the responsibility of proxy government, contemporary capitalism is, in some cases, best served by the collapse of states. Resource-rich geographical zones are therefore transformed into ‘anarchic zones’ where there is no effective state power and access to resources is controlled by warlords and armed gangs. The sale of resources from these zones is rarely inhibited by the manifest illegitimacy of the groups selling those assets. For example, in 2014 ISIL, despite its designation as a terrorist organisation by the UN, was selling US\$1 million per day of oil from captured Iraqi wells (Crane, 2015; Leigh, 2014). The priority has become the extraction of wealth, rather than the protection of human life.

From this vantage point, failed states – which are themselves the source of many asylum seekers – are the direct and non-accidental result of neo-colonial exploitation.

The first thing is to recall that most refugees come from ‘failed states’, states where public authority is more or less inoperative, at least in large parts of the countries in question (Syria, Lebanon, Iraq, Libya, Somalia, Congo, and so on). In all these instances, this disintegration of state power is not purely a local phenomenon but the result of international economics and politics; in some cases, such as in Libya and Iraq, it is even a direct outcome of Western intervention. It is clear that this rise of ‘failed states’ in the late twentieth and twenty-first centuries is not an unintended misfortune; rather, it is one of the ways in which the great powers practise their economic colonialism. (Žižek, 2016: 45–6)

The triumph of capitalism has thus, this reading suggests, produced profound inequality and instability at both the macro and micro levels. The richest $1 \%$ own $4 7 \%$ of the world’s wealth, and the top $10 \%$ possess $8 5 \%$ . By contrast, the poorest $50 \%$ of the population own just $1 \%$ of global wealth (Shorrocks et al., 2018). From a capitalist perspective, there are over 2 billion people in the world who ‘count for nothing’, because ‘they are neither consumers, nor a labour force’ (Badiou, 2015: 14). At the level of daily existence, feelings of fear and vulnerability are ubiquitous (Bauman, 2016) – not only for those who ‘count for nothing’, but also for the masses of workers who fully understand their expendability within this system (Standing, 2014).

From this political-economic perspective, the global economic order is largely culpable for the conflicts from which people seek asylum. At the same time, the neoliberal world order is responsible for the production of a population of workers and consumers who feel vulnerable, fearful and angry about their circumstances. The loss of job security and protections and the decline in labour’s share of social wealth are economic facts. However, in encouraging workers to identify surplus labour from migration as the cause of this precarity, conservative politicians make asylum seekers into the target for these emotions. In this context, the xenophobic discourses described earlier can be seen as conscious political strategies. The propagation of false beliefs regarding supposed ‘economic migration’ serves powerful political interests, protecting capitalist hegemony while (ironically) fuelling the rise of the very forms of reactionary politics that typically erode the rights of workers (Smith, 2016: 155). The proper targets of workers’ fears and anger are the governments and global corporations that facilitate exploitation, but the maintenance of capitalist power relies on the redirection of this hostility onto a scapegoat (Žižek, 2016).

This model of xenophobia connects with those described earlier in that it provides an overarching explanatory narrative regarding why governments around the world perpetuate false beliefs, appeal to racial prejudice and push psychological ‘buttons’ to produce xenophobia. While the form that these strategies take is always conditioned by local political, cultural and economic factors (Poynting and Briskman, 2018), this model argues that it is also essential to grasp the explanatory importance of global economic forces for understanding xenophobia.

# Conclusion

This article has reviewed four of the main causal theories that seek to explain contemporary xenophobia – particularly as it effects asylum seekers. In doing so, it has made a case for the multifactorial character of xenophobia. While this article has highlighted some differences in how xenophobia has been theorised from different disciplinary perspectives, it has also demonstrated that these research programs do not have to be seen as competing or opposing models. In some areas they furnish mutually reinforcing arguments that help to illuminate the complexity of xenophobia.

This characterisation of xenophobia has implications for theory as it suggests opportunities for greater interdisciplinary engagement. It also raises important considerations for those seeking to combat xenophobia. On one hand, this review reinforces existing research regarding the effectiveness of localised anti-prejudice interventions (Pedersen et al., 2011). Alarmist discourses may function to validate (and provide a script to obfuscate) racist perspectives, or to activate underlying psychological predispositions towards xenophobia. As such, efforts to correct misinformation – even at the individual level – may have merit. Equally, given social psychology’s consistent findings regarding the instinctive nature of xenophobia (Haidt, 2012, 2013), interventions that speak to the individual’s emotions and moral intuitions – for example, by facilitating humanising relationships between opposing parties – may do more to erode or redefine group boundaries than purely informational campaigns. As Haidt (2013: 289) notes, ‘intuitions come first, strategic reasoning second’.

On the other hand, this article offers an important caveat to such arguments by highlighting structural explanations of xenophobia. From this perspective, local manifestations of xenophobia should be understood as symptoms of a much broader disease rather than a discrete malady. It may be tempting to focus exclusively on local factors, for example the prevalence of specific false beliefs, as such causal narratives appear to offer clear remedies, but to do so would be to oversimply a complex and multifactorial phenomenon. An adequate account of xenophobia needs to resist the reductionist tendency to mono-dimensional explanations. Xenophobia is always a local and a global phenomenon, a psychological and cultural phenomenon, and a problem that is simultaneously politically manufactured and constraining of political possibility.

# Funding

The author(s) received no financial support for the research, authorship, and/or publication of this article.

# References

Augoustinos, M. and D. Every (2007) ‘The Language of “Race” and Prejudice: A Discourse of Denial, Reason, and Liberal-Practical Politics’, Journal of Language and Social Psychology 26: 123–41.   
Augoustinos, M. and C. Quinn (2003) ‘Social Categorization and Attitudinal Evaluations: Illegal Immigrants, Refugees or Asylum Seekers?’, New Review of Social Psychology 2(1): 29–37.   
Badiou, A. (2015) ‘Our Wound is Not So Recent’, trans. R. Mackay. Lecture delivered at La Commune Theatre, Aubervilliers, 23 November.   
Bauman, Z. (2016) Liquid Fear. Cambridge: Polity.   
Briskman, L. (2015) ‘The Creeping Blight of Islamophobia in Australia’, International Journal for Crime, Justice and Social Democracy 4(3): 112–21.   
Burroughs, E. (2015) ‘The Discourse of Controlling “Illegal Immigration” in Irish Parliamentary Texts’, Journal of Language and Politics 14(4): 479–500.   
Carson, A., Y. Dufresne and A. Martin (2016) ‘Wedge Politics: Mapping Voter Attitudes to Asylum Seekers Using Large-scale Data During the Australian 2013 Federal Election Campaign’, Policy and Internet 8: 478–98.   
Crane, K. (2015) ‘The Role of Oil in ISIL Finances: Testimony Presented Before the Senate Energy and Natural Resources Committee on December 10, 2015’, RAND Office of External Affairs, USA.   
Crawley, H. (2005) Evidence on Attitudes to Asylum and Immigration: When We Know, Don’t Know and Need to Know. Working paper 23, Centre on Migration, Policy and Society. Oxford: University of Oxford.   
Daly, M. (2015) ‘Sociobiology: Overview’, , pp. 908–11 in J.D. Wright (ed.) International Encyclopedia of the Social and Behavioral Sciences, 2nd edn. London: Elsevier.   
Darwin, C. (1998 [1871]) The Descent of Man and Selection in Relation to Sex. New York: Prometheus Books.   
Dunn, K.M., N. Klocker and T. Salabay (2007) ‘Contemporary Racism and Islamaphobia in Australia: Racializing Religion’, Ethnicities 7: 564–89.   
Every, D. and M. Augoustinos (2007) ‘Constructions of Racism in the Australian Parliamentary Debates on Asylum Seekers’, Discourse & Society 18: 411–36.   
Green, L. (2003) ‘The New “Others”: Media and Society Post-September 11’, Media International Australia 109: 7–13.   
Haidt, J. (2012) The Righteous Mind: Why Good People Are Divided by Politics and Religion. New York: Pantheon Books.   
Haidt, J. (2013) ‘Moral Psychology for the Twenty-first Century’, Journal of Moral Education 42(3): 281–95.   
Herman, E.S. and N. Chomsky (1998) Manufacturing Consent: The Political Economy of the Mass Media. New York: Pantheon Books.   
Jackson, L.B. (2018) ‘Islamophobia and National Identity in Europe’, pp. 115–44 in L.B. Jackson (ed.) Islamophobia in Britain: The Making of a Muslim Enemy. Cham, Switzerland: Palgrave Macmillan.   
Kivisto, P. (2008) ‘Xenophobia’, pp. 1041–3 in V.N. Parrillo (ed.) Encyclopedia of Social Problems. Thousand Oaks, CA: Sage.   
Klocker, M. (2004) ‘Community Antagonism Towards Asylum Seekers in Port Augusta, South Australia’, Australian Geographical Studies 42(1): 1–17.   
Klocker, N. and K.M. Dunn (2003) ‘Who’s Driving the Asylum Debate? Newspaper and Government Representations of Asylum Seekers’, Media International Australia, Incorporating Culture and Policy 109: 71–92.   
Leigh, K. (2014) ‘ISIS Makes Up to $\$ 3$ Million a Day Selling Oil, Say Analysts’, ABC News, 2 August .   
Levin, J. and J. McDevitt (2002) ‘Hatred Around the World: Keeping Foreigners Out’, in Hate Crimes Revisited: America’s War on Those Who Are Different. Boulder, CO: Westview Press.   
Linke, U. and D.T. Smith (2009) ‘Fear: A Conceptual Framework’, pp. 1–17 in U. Linke and D.T. Smith (eds) Cultures of Fear: A Critical Reader. London: Pluto Press.   
McAdam, J. and F. Chong (2014) Refugees: Why Seeking Asylum Is Legal and Australia’s Policies Are Not. Sydney: UNSW Press.   
McGrew, A. (2010) ‘Globalization and Global Politics’, pp. 13–31 in J. Baylis, P. Owens and S. Smith (eds) The Globalization of World Politics. Oxford: Oxford University Press.   
McHugh-Dillon, H. (2015) If They Are Genuine Refugees, Why? Public Attitudes to Unauthorised Arrivals in Australia. Victoria, Australia: Victorian Foundation for Survivors of Torture.   
McKay, F.H., S.L. Thomas and R.W. Blood (2011) ‘“Any One of These Boat People Could be a Terrorist for All We Know!” Media Representations and Public Perceptions of “Boat People” Arrivals in Australia’, Journalism 12(5): 607–26.   
McKay, F.H., S.L. Thomas and S. Kneebone (2012) ‘“It Would Be Okay If They Came through the Proper Channels”: Community Perceptions and Attitudes Towards Asylum Seekers in Australia’, Journal of Refugee Studies 25: 113–33.   
MacKenzie, D. (2016) ‘On the Road Again’, New Scientist April: 30–8.   
Maddox, M. (2004) ‘“People Like That”: Race, Religion and Values in Recent Australian Political Rhetoric’, in Proceedings of the Australasian Political Studies Association 2004 Conference. Adelaide, Australia: Australian Political Studies Association.   
Mainwaring, S. and C. Silverman (2017) ‘Detention-as-Spectacle’, International Political Sociology 11(1): 21–38.   
Markus, A. (2013) Mapping Social Cohesion: The Scanlon Foundation Surveys National Report. Clayton, Vic.: Monash Institute for the Study of Global Movements.   
Monbiot, G. (2016) How Did We Get into This Mess? Politics, Equality, Nature. London: Verso.   
Nagel, C. (2016) ‘Southern Hospitality? Islamophobia and the Politicization of Refugees in South Carolina during the 2016 Election Season’, Southeastern Geographer 56(3): 283–90.   
Ogan, C., L. Willnat, R. Pennington and M. Bashir (2013) ‘The Rise of Anti-Muslim Prejudice: Media and Islamophobia in Europe and the United States’, International Communication Gazette 76(1): 27–46.   
Ogan, C., R. Pennington, O. Venger and D. Metz (2018) ‘Who Drove the Discourse? News Coverage and Policy Framing of Immigrants and Refugees in the 2016 US Presidential Election’, Communications 43(3): 357–78.   
Ortona, G. (2017) ‘Xenophobia Is Really That: A (Rational) Fear of the Stranger’, Mind & Society 16: 37–49.   
Papastergiadis, N. (2004) ‘The Invasion Complex in Australian Political Culture’, Thesis Eleven 78(August): 8–27.   
Pedersen, A. and L. Hartley (2015) ‘Can We Make a Difference? Prejudice Towards Asylum Seekers in Australia and the Effectiveness of Antiprejudice Interventions’, Journal of Pacific Rim Psychology 9(1): 1–14.   
Pedersen, A. and L. Hartley (2017) ‘False Beliefs about Asylum Seekers to Australia: The Role of Confidence in Such Beliefs, Prejudice, and the Third Person Effect’, Journal of Pacific Rim Psychology 11(5): 1–12.   
Pedersen, A., J. Attwell and D. Heveli (2005) ‘Prediction of Negative Attitudes towards Asylum Seekers: False Beliefs, Nationalism, and Self-esteem’, Australian Journal of Psychology 57(3): 148–60.   
Pedersen, A., S. Watt and S. Hansen (2006) ‘The Role of False Beliefs in the Community’s and the Federal Government’s Attitudes towards Australian Asylum Seekers’, Australian Journal of Social Issues 41(1): 105–24.   
Pedersen, A., Y. Paradies, L. Hartley and K. Dunn (2011) ‘Bystander Antiprejudice: Cross-cultural Education, Links with Positivity towards Cultural “Outgroups” and Preparedness to Speak Out’, Journal of Pacific Rim Psychology 5: 19–30.   
Peterie, M. (2018) ‘Deprivation, Frustration and Trauma: Immigration Detention Centres as Prisons’, Refugee Survey Quarterly 37(3): 279–306.   
Peterie, M. (2019a) ‘Technologies of Control: Asylum Seeker and Volunteer Experiences in Australian Immigration Detention Facilities’, Journal of Sociology 55(2): 181–98.   
Peterie, M. (2019b) ‘Compassion and Power: (Emotional) Reflexivity in Asylum Seeker Friendship Programmes’, in R. Patulny, A. Bellocchi, R. Olson, S. Khorana, J. McKenzie and M. Peterie (eds) Emotions in Late Modernity. New York: Routledge.   
Poynting, S. and L. Briskman (2018) ‘Islamophobia in Australia: From Far-right Deplorables to Respectable Liberals’, Social Sciences 7: 1–17.   
Poynting, S. and V. Mason (2007) ‘The Resistible Rise of Islamophobia: Anti-Muslim Racism in the UK and Australia before 11 September 2001’, Journal of Sociology 43(1): 61–96.   
Poynting, S. and G. Noble (2004) Living with Racism: The Experience and Reporting by Arab and Muslim Australians of Discrimination, Abuse and Violence since 11 September 2001. Report to the Human Rights and Equal Opportunity Commission, University of Western Sydney Centre for Cultural Research, Western Sydney.   
Poynting, S., G. Noble, P. Tabar and J. Collins (2004) Bin Laden in the Suburbs: Criminalising the Arab Other, Sydney: Sydney Institute of Criminology Series.   
Pugliese, J. (2008) ‘The Tutelary Architecture of Immigration Detention Prisons and the Spectacle of “Necessary Suffering”’, Architectural Theory Review 13: 206–21.   
Randell-Moon, H. (2006) ‘“Common Values”: Whiteness, Christianity, Asylum Seekers and the Howard Government’, Australian Critical Race and Whiteness Studies Association e-Journal 2: 1–14.   
Robjant, K., R. Hassan and C. Katona (2009) ‘Mental Health Implications of Detaining Asylum Seekers: Systematic Review’, British Journal of Psychiatry 194: 306–12.   
Said, E.W. (2003 [1978]) Orientalism. London: Penguin.   
Sanchez-Mazas, M. and L. Licata (2015) ‘Xenophobia: Social Psychological Aspects’, pp. 802–7 in J.D. Wright (ed.) International Encyclopedia of the Social and Behavioral Sciences, 2nd edn. London: Elsevier.   
Shaxson, N. (2011) Treasure Islands: Tax Havens and the Men who Stole the World. New York: Palgrave Macmillan.   
Shorrocks, A., J. Davies and R. Lluberas (2018) Global Wealth Report 2018. Zurich: Credit Suisse.   
Smith, J. (2016) Imperialism in the Twenty-first Century: Globalization, Super-exploitation, and Capitalism’s Final Crisis. New York: Monthly Review Press.   
Spinney, A. and A. Nethery (2013) ‘Taking Our Houses’: Perceptions of the Impact of Asylum Seekers, Refugees and new Migrants on Housing Assistance in Melbourne’, Social Policy and Society 12(2): 179–89.   
Standing, G. (2014) ‘The Precariat’, Contexts 13(4): 10–12.   
van Dijk, T.A. (1992) ‘Discourse and the Denial of Racism’, Discourse & Society 3: 87–118.   
Wilson, D.S. (2002) Darwin’s Cathedral: Evolution, Religion and the Nature of Society. Chicago: University of Chicago Press.   
Wilson, E.O. (2004) On Human Nature: With a New Preface. Cambridge, MA: Harvard University Press.   
Žižek, S. (2016) Against the Double Blackmail: Refugees, Terror and Other Troubles with the Neighbours. London: Allen Lane.

# Author biographies

Michelle Peterie is a Postdoctoral Research Fellow in the School of Social Science at the University of Queensland. Her research concerns bureaucratic violence and the socio-emotional impacts of punitive policies and discourses. Her work has been published in Australian and international journals and submitted as evidence at legal hearings. She won the biennial award for the best article in the Journal of Sociology 2017–18.

David Neil is a lecturer in the Philosophy Program at the University of Wollongong (UOW) and his teaching is primarily in the area of ethics. His research interests are in political philosophy, ethical theory and applied ethics. Prior to his appointment at UOW he was a lecturer in the School of Philosophy and Bioethics at Monash University.